<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Notification\Base as Notification;
127
?>

<form method="post" autocomplete="off">

    <div class="ulz-meta-container ulz-container-left">
        <h1><?php esc_html_e( 'Settings', 'utillz-core' ); ?></h1>
    </div>

    <div class="ulz-panel ulz-loading ulz-outer" id="ulz-panel" data-tab-start="general/units" :class="{ 'ulz-ready' : ready }">

        <input type="hidden" name="utillz_current_tab" v-bind:value="tab">

        <div class="ulz-header">

            <div class="ulz-site-logo">
                <h3 class="ulz--name"><a href="https://utillz.com" target="_blank"><?php esc_html_e('Utillz', 'utillz-core'); ?></a></h3>
            </div>

            <nav class="ulz-nav">
                <ul>

                    <li :class="{ 'ulz-active': tabMain == 'general' }">
                        <a href="#" v-on:click.prevent="tabClick('general/units')">
                            <?php esc_html_e( 'General', 'utillz-core' ); ?>
                        </a>
                    </li>
                    <li :class="{ 'ulz-active': tabMain == 'listings' }">
                        <a href="#" v-on:click.prevent="tabClick('listings/taxonomies-built-in')">
                            <?php esc_html_e( 'Listings', 'utillz-core' ); ?>
                        </a>
                    </li>
                    <li :class="{ 'ulz-active': tabMain == 'explore' }">
                        <a href="#" v-on:click.prevent="tabClick('explore/general')">
                            <?php esc_html_e( 'Explore', 'utillz-core' ); ?>
                        </a>
                    </li>
                    <li :class="{ 'ulz-active': tabMain == 'integration' }">
                        <a href="#" v-on:click.prevent="tabClick('integration/maps')">
                            <?php esc_html_e( 'Integration', 'utillz-core' ); ?>
                        </a>
                    </li>

                    <?php do_action('utillz/settings/tab-main'); ?>

                </ul>
            </nav>

            <div class="ulz-header-guide ulz-ml-auto">
                <a href="https://utillz.com/docs/" class="ulz-docs" target="_blank">
                    <div class="ulz--icon ulz-mr-1">
                        <i class="material-icons">library_books</i>
                    </div>
                    <div class="ulz--content">
                        <?php esc_html_e('User Guide', 'utillz-core'); ?>
                    </div>
                </a>
            </div>

        </div> <!-- ulz-header -->

        <div class="ulz-sub-navs">

            <!-- general -->
            <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'general'">
                <li :class="{ 'ulz-active': tabSub == 'units' }">
                    <a href="#" v-on:click.prevent="tabClick('general/units')">
                        <?php esc_html_e( 'Units', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabSub == 'pages' }">
                    <a href="#" v-on:click.prevent="tabClick('general/pages')">
                        <?php esc_html_e( 'Pages', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabSub == 'payouts' }">
                    <a href="#" v-on:click.prevent="tabClick('general/payouts')">
                        <?php esc_html_e( 'Payouts', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabSub == 'notifications' }">
                    <a href="#" v-on:click.prevent="tabClick('general/notifications')">
                        <?php esc_html_e( 'Notifications', 'utillz-core' ); ?>
                    </a>
                </li>
                <?php if( WP_DEBUG == true ): ?>
                    <li :class="{ 'ulz-active': tabSub == 'dev' }">
                        <a href="#" v-on:click.prevent="tabClick('general/dev')">
                            <?php esc_html_e( 'Dev', 'utillz-core' ); ?>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>

            <!-- listings -->
            <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'listings'">
                <li :class="{ 'ulz-active': tabSub == 'taxonomies-built-in' }">
                    <a href="#" v-on:click.prevent="tabClick('listings/taxonomies-built-in')">
                        <?php esc_html_e( 'Built-in Taxonomies', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabSub == 'taxonomies-custom' }">
                    <a href="#" v-on:click.prevent="tabClick('listings/taxonomies-custom')">
                        <?php esc_html_e( 'Custom Taxonomies', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabSub == 'social' }">
                    <a href="#" v-on:click.prevent="tabClick('listings/social')">
                        <?php esc_html_e( 'Social Sharing', 'utillz-core' ); ?>
                    </a>
                </li>
            </ul>

            <!-- explore -->
            <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'explore'">
                <li :class="{ 'ulz-active': tabSub == 'general' }">
                    <a href="#" v-on:click.prevent="tabClick('explore/general')">
                        <?php esc_html_e( 'General', 'utillz-core' ); ?>
                    </a>
                </li>
            </ul>

            <!-- integration -->
            <ul class="ulz-sub-nav ulz-shade" v-if="tabMain == 'integration'">
                <li :class="{ 'ulz-active': tabSub == 'maps' }">
                    <a href="#" v-on:click.prevent="tabClick('integration/maps')">
                        <?php esc_html_e( 'Maps', 'utillz-core' ); ?>
                    </a>
                </li>
                <li :class="{ 'ulz-active': tabSub == 'account' }">
                    <a href="#" v-on:click.prevent="tabClick('integration/account')">
                        <?php esc_html_e( 'Account', 'utillz-core' ); ?>
                    </a>
                </li>
            </ul>

            <?php do_action('utillz/settings/tab-sub'); ?>

        </div>

        <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'general'}">

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'units'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'General', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form = new Form( Form::Storage_Option );

                        $form->render([
                            'type' => 'key',
                            'id' => 'listing_slug',
                            'name' => esc_html__('Listing slug', 'utillz-core'),
                            'description' => esc_html__('You need to re-save the permalink format after changing this option in order to apply the slug correctly', 'utillz-core'),
                            'placeholder' => 'listing',
                            'defined' => false,
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'currency_place',
                            'name' => esc_html__('Currency place', 'utillz-core'),
                            'options' => [
                                'left' => 'Left',
                                'right' => 'Right',
                            ],
                            'value' => 'left',
                            'allow_empty' => false,
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'currency_symbol',
                            'name' => esc_html__('Currency symbol', 'utillz-core'),
                            'value' => '$',
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'measure_system',
                            'name' => esc_html__('Measuring system', 'utillz-core'),
                            'value' => 'imperial',
                            'options' => [
                                'imperial' => esc_html__('British imperial system (miles)', 'utillz-core'),
                                'metric' => esc_html__('Metric system (kilometers)', 'utillz-core'),
                            ],
                            'allow_empty' => false
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'decimals',
                            'name' => esc_html__('Number format decimals', 'utillz-core'),
                            'value' => 2,
                            'options' => [
                                0 => 0,
                                1 => 1,
                                2 => 2,
                            ],
                            'allow_empty' => false,
                            'col' => 4
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'decimal_separator',
                            'name' => esc_html__('Number format decimal separator', 'utillz-core'),
                            'value' => '.',
                            'col' => 4
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'thousands_separator',
                            'name' => esc_html__('Number format thousands separator', 'utillz-core'),
                            'value' => ',',
                            'col' => 4
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'pages'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Pages', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form">
                    <div class="ulz-grid">
                        <?php

                            $form->render([
                                'type' => 'select',
                                'id' => 'page_explore',
                                'name' => esc_html__('Explore page', 'utillz-core'),
                                'options' => [
                                    'query' => [
                                        'post_type' => 'page',
                                        'posts_per_page' => -1,
                                    ]
                                ]
                            ]);

                            $form->render([
                                'type' => 'select',
                                'id' => 'page_submission',
                                'name' => esc_html__('Submission page', 'utillz-core'),
                                'options' => [
                                    'query' => [
                                        'post_type' => 'page',
                                        'posts_per_page' => -1,
                                    ]
                                ]
                            ]);

                            do_action('utillz/settings/page');

                        ?>

                        <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                            <button type="submit" class="ulz-button ulz--large">
                                <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                            </button>
                        </div>

                    </div>
                </div>
            </aside>

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'payouts'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Payouts', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_payouts',
                            'name' => esc_html__('Enable payouts', 'utillz-core'),
                        ]);




                        $form->render([
                            'type' => 'checklist',
                            'id' => 'payout_methods',
                            'name' => esc_html__('Payout methods', 'utillz-core'),
                            'value' => [],
                            'options' => [
                                'paypal' => 'PayPal',
                                'bank_transfer' => 'Direct bank transfer',
                            ],
                            'dependency' => [
                                'id' => 'enable_payouts',
                                'value' => 1,
                                'compare' => '=',
                                'style' => 'ulz-opacity-30',
                            ],
                        ]);

                        $form->render([
                            'type' => 'number',
                            'id' => 'min_payout',
                            'name' => esc_html__('Minimum payouts amount', 'utillz-core'),
                            'min' => 0,
                            'step' => 0.01,
                            'dependency' => [
                                'id' => 'enable_payouts',
                                'value' => 1,
                                'compare' => '=',
                                'style' => 'ulz-opacity-30',
                            ],
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'notifications'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Notifications', 'utillz-core' ); ?></h3>
                    <p><?php esc_html_e( 'Here you can manage site notifications email templates and webhooks', 'utillz-core' ); ?></p>
                </div>

                <?php $notifications = Notification::get_notifications(); ?>

                <div class="ulz-settings-split">
                    <div class="ulz--sidebar">
                        <ul>
                            <?php $active = false; foreach( $notifications as $base => $namespace ): ?>
                                    <li <?php if( ! $active ) { echo 'class="ulz--active"'; } ?> data-for="<?php echo esc_attr( $base ); ?>">
                                        <a href="#">
                                            <?php echo esc_html( ucfirst( str_replace( '-', ' ', $base ) ) ); ?>
                                        </a>
                                    </li>
                                <?php $active = true; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="ulz--content">

                        <div class="ulz-form">
                            <?php $active = false; foreach( $notifications as $base => $namespace ): ?>
                                <div class="ulz--section<?php if( ! $active ) { echo ' ulz--active'; } ?>" data-id="<?php echo esc_attr( $base ); ?>">
                                    <div class="ulz-grid">
                                        <?php

                                            $notification = new $namespace;
                                            $id = $notification->get_id();

                                            $form->render([
                                                'type' => 'checkbox',
                                                'id' => sprintf('is_notification_site_%s', $id ),
                                                'name' => esc_html__('Send site notification', 'utillz-core'),
                                                'html' => [
                                                    'text' => esc_html__( 'Enable', 'utillz-core' )
                                                ],
                                            ]);

                                            ?>

                                            <div class="ulz-form-group ulz-field ulz-col-12" data-dependency='{"id":"is_notification_site_<?php echo esc_attr( $id ); ?>","value":true,"compare":"="}'>
                                                <p class="ulz-mb-1"><?php esc_html_e( 'Preview', 'utillz-core' ); ?>:</p>
                                                <div class="ulz-in-site-preview">
                                                    <div class="ulz--inner">
                                                        <?php if( is_array( $icon = $notification->get_site_icon() ) ): ?>
                                                            <div class="ulz--icon">
                                                                <?php echo utillz_core()->icon()->get( $icon['icon'], $icon['set'] ) ?>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if( $text = $notification->get_site_message() ): ?>
                                                            <div class="ulz--text">
                                                                <?php echo esc_html( $text ); ?>
                                                                <span class="ulz--date">
                                                                    <?php echo date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( date('U') ) ); ?>
                                                                </span>
                                                            </div>
                                                        <?php endif; ?>
                                                        <div class="ulz--status">
                                                            <span></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php

                                            $form->render([
                                                'type' => 'separator',
                                            ]);

                                            $form->render([
                                                'type' => 'checkbox',
                                                'id' => sprintf('is_notification_email_%s', $id ),
                                                'name' => esc_html__('Send email to user', 'utillz-core'),
                                                'html' => [
                                                    'text' => esc_html__( 'Enable', 'utillz-core' )
                                                ],
                                            ]);

                                            $email_template = $form->create([
                                                'type' => 'textarea',
                                                'id' => sprintf('notification_email_template_%s', $id ),
                                                'name' => esc_html__('Email template to user', 'utillz-core'),
                                                'description' => sprintf( esc_html__('Use plain text only. For emails with HTML templates, you can use the webhooks', 'utillz-core'), '<a href="#" data-modal="field-template"><strong>' . esc_html__('custom fields', 'utillz-core') . '</strong></a>' ),
                                                'dependency' => [
                                                    'id' => sprintf('is_notification_email_%s', $id ),
                                                    'value' => true,
                                                    'compare' => '=',
                                                ],
                                            ]);

                                            if( empty( $email_template->props->value ) ) {
                                                $email_template->props->value = $notification->get_email_admin_template();
                                            }

                                            echo $email_template->get();

                                            $form->render([
                                                'type' => 'separator',
                                            ]);

                                            $form->render([
                                                'type' => 'checkbox',
                                                'id' => sprintf('is_notification_email_admin_%s', $id ),
                                                'name' => esc_html__('Send email to the admin', 'utillz-core'),
                                                'html' => [
                                                    'text' => esc_html__( 'Enable', 'utillz-core' )
                                                ],
                                            ]);

                                            $email_template_admin = $form->create([
                                                'type' => 'textarea',
                                                'id' => sprintf('notification_email_template_admin_%s', $id ),
                                                'name' => esc_html__('Email template to admin', 'utillz-core'),
                                                'description' => sprintf( esc_html__('Use plain text only. For emails with HTML templates, you can use the webhooks', 'utillz-core'), '<a href="#" data-modal="field-template"><strong>' . esc_html__('custom fields', 'utillz-core') . '</strong></a>' ),
                                                'dependency' => [
                                                    'id' => sprintf('is_notification_email_admin_%s', $id ),
                                                    'value' => true,
                                                    'compare' => '=',
                                                ],
                                            ]);

                                            if( empty( $email_template_admin->props->value ) ) {
                                                $email_template_admin->props->value = $notification->get_email_admin_template();
                                            }

                                            echo $email_template_admin->get();

                                            $form->render([
                                                'type' => 'separator',
                                            ]);

                                            $form->render([
                                                'type' => 'checkbox',
                                                'id' => sprintf('is_notification_webhook_%s', $id ),
                                                'name' => esc_html__('Enable webhook', 'utillz-core'),
                                                'html' => [
                                                    'text' => esc_html__( 'Enable', 'utillz-core' )
                                                ],
                                            ]);

                                            $form->render([
                                                'type' => 'heading',
                                                'name' => esc_html__('Webhook URL', 'utillz-core'),
                                                'description' => sprintf(
                                                    esc_html__("The webhook is a way for an app to provide other applications with real-time information\r\n %s\r\n %s", 'utillz-core'),
                                                    '<a href="https://utillz.com/documentation/account/notifications/webhooks/" target="_blank">' . esc_html__('Learn more abount webhooks', 'utillz-core') . '</a>',
                                                    '<a href="#" data-modal="panel-field-webhook">' . esc_html__('What fields are being sent to the webhook url', 'utillz-core') . '</a>'
                                                ),
                                                'dependency' => [
                                                    'id' => sprintf('is_notification_webhook_%s', $id ),
                                                    'value' => true,
                                                    'compare' => '=',
                                                ],
                                                'class' => [
                                                    'ulz-mb-0'
                                                ]
                                            ]);

                                            $form->render([
                                                'type' => 'text',
                                                'id' => sprintf('notification_webhook_url_%s', $id ),
                                                'dependency' => [
                                                    'id' => sprintf('is_notification_webhook_%s', $id ),
                                                    'value' => true,
                                                    'compare' => '=',
                                                ],
                                                'col' => 6
                                            ]);

                                            ?>

                                            <div class="ulz-form-group ulz-field ulz-col-6" data-dependency='{"id":"is_notification_webhook_<?php echo esc_attr( $id ); ?>","value":true,"compare":"="}'>
                                                <a href="#" class="ulz-button ulz-small ulz--secondary" data-action="trigger-webhook" data-for="<?php echo sprintf('notification_webhook_url_%s', $id ); ?>">
                                                    <span><?php esc_html_e( 'Trigger webhook', 'utillz-core' ); ?></span>
                                                    <?php Ucore()->preloader(); ?>
                                                </a>
                                            </div>

                                            <?php

                                            $form->render([
                                                'type' => 'text',
                                                'id' => sprintf('notification_webhook_custom_fields_%s', $id ),
                                                'name' => esc_html__('Webhook custom fields', 'utillz-core'),
                                                'description' => sprintf(
                                                    esc_html__('%s: you can add additional custom meta fields using a simple comma-separated string, like: %s. webhook_param_name stands for the parameter name that will be sent to the webhook and listing_meta_key stands for the post meta key, that you want to extract from the listing and send. The post meta value will be collected from the listing post type', 'utillz-core'),
                                                    '<strong>' . esc_html__('Advanced users only', 'utillz-core') . '</strong>',
                                                    '<strong>webhook_param_name:listing_meta_key</strong>'
                                                ),
                                                'dependency' => [
                                                    'id' => sprintf('is_notification_webhook_%s', $id ),
                                                    'value' => true,
                                                    'compare' => '=',
                                                ],
                                            ]);

                                            ?>

                                            <?php

                                            $active = true;

                                        ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="ulz-mt-2">
                            <button type="submit" class="ulz-button ulz--large">
                                <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                            </button>
                        </div>

                    </div>
                </div>

            </aside>

            <?php if( WP_DEBUG == true ): ?>
                <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'dev'}">
                    <div class="ulz-panel-heading">
                        <h3 class="ulz-title"><?php esc_html_e( 'Development', 'utillz-core' ); ?></h3>
                        <p><?php esc_html_e( 'This section is for development purposes only', 'utillz-core' ); ?></p>
                    </div>

                    <div class="ulz-form ulz-grid">
                        <div class="ulz-form-group ulz-col-12">
                            <div class="ulz-development">
                                <div class="ulz--export">
                                    <a href="#" class="ulz-button ulz--large ulz--secondary" data-action="dev-export-options">
                                        <span><?php esc_html_e( 'Export options', 'utillz-core' ); ?></span>
                                        <?php Ucore()->preloader(); ?>
                                    </a>
                                </div>
                                <div class="ulz--output">
                                    <!-- // -->
                                </div>
                            </div>
                        </div>
                        <div class="ulz-form-group ulz-col-12 ulz-none" id="ulz-input-options-export">
                            <div class="ulz-heading">
                                <label class="ulz-ellipsis"><?php esc_html_e( 'JSON export', 'utillz-core' ); ?></label>
                            </div>
                            <textarea type="text"></textarea>
                        </div>
                    </div>

                </aside>
            <?php endif; ?>

        </section>

        <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'listings'}">

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'taxonomies-built-in'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Built-in Taxonomies', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form->render([
                            'type' => 'heading',
                            'description' => esc_html__('Here you can manage your built-in taxonomies like tags, regions and categories. After changing any option in this section, you need to re-save your permalink by going to Settings > Permalinks, in order to flush your rewrite rules.', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'tax_category_public',
                            'name' => esc_html__('Public category term', 'utillz-core'),
                            'description' => esc_html__('Check this option if you want to make the category term public.', 'utillz-core'),
                            'value' => true,
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'tax_category_slug',
                            'name' => esc_html__('Custom category slug', 'utillz-core'),
                            'description' => esc_html__('If you like, you may enter custom structures for your listing category URLs here.', 'utillz-core'),
                            'placeholder' => 'listing-category',
                            'dependency' => [
                                'id' => 'tax_category_public',
                                'value' => true,
                            ],
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'tax_region_public',
                            'name' => esc_html__('Public region term', 'utillz-core'),
                            'description' => esc_html__('Check this option if you want to make the region term public.', 'utillz-core'),
                            'value' => true,
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'tax_region_slug',
                            'name' => esc_html__('Custom region slug', 'utillz-core'),
                            'description' => esc_html__('If you like, you may enter custom structures for your listing region URLs here.', 'utillz-core'),
                            'placeholder' => 'listing-region',
                            'dependency' => [
                                'id' => 'tax_region_public',
                                'value' => true,
                            ],
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'tax_tag_public',
                            'name' => esc_html__('Public tag term', 'utillz-core'),
                            'description' => esc_html__('Check this option if you want to make the tag term public.', 'utillz-core'),
                            'value' => true,
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'tax_tag_slug',
                            'name' => esc_html__('Custom tag slug', 'utillz-core'),
                            'description' => esc_html__('If you like, you may enter custom structures for your listing tag URLs here.', 'utillz-core'),
                            'placeholder' => 'listing-tag',
                            'dependency' => [
                                'id' => 'tax_tag_public',
                                'value' => true,
                            ],
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'taxonomies-custom'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Custom Taxonomies', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form->render([
                            'type' => 'repeater',
                            'id' => 'custom_taxonomies',
                            'name' => esc_html__('Custom taxonomies', 'utillz-core'),
                            'button' => [
                                'label' => esc_html__('Add taxonomy', 'utillz-core')
                            ],
                            'templates' => [

                                /*
                                 * custom taxonomy
                                 *
                                 */
                                'text' => [
                                    'name' => 'Taxonomy',
                                    'heading' => 'name',
                                    'fields' => [
                                        'name' => [
                                            'type' => 'text',
                                            'name' => esc_html__( 'Name', 'utillz-core' ),
                                            'placeholder' => esc_html__( 'Amenities', 'utillz-core' ),
                                            'col' => 6
                                        ],
                                        'slug' => [
                                            'type' => 'key',
                                            'name' => esc_html__( 'Taxonomy slug', 'utillz-core' ),
                                            'placeholder' => 'amenities',
                                            'defined' => false,
                                            'col' => 6
                                        ],
                                        'tax_public' => [
                                            'type' => 'checkbox',
                                            'name' => esc_html__( 'Public term', 'utillz-core' ),
                                            'description' => esc_html__('Check this option if you want to make the term public and display an archive page on the front-end. After changing this option, make sure to re-save your permalink format.', 'utillz-core'),
                                        ],
                                    ]
                                ],

                            ]
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'social'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Social Sharing', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_share',
                            'name' => esc_html__('Enable listing sharing', 'utillz-core'),
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

        </section>

        <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'explore'}">

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'general'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Explore', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form->render([
                            'type' => 'select',
                            'id' => 'global_pagination_type',
                            'name' => esc_html__('Pagination type', 'utillz-core'),
                            'options' => [
                                'paging' => esc_html__('Paging', 'utillz-core'),
                                'more' => esc_html__('Load more button', 'utillz-core'),
                                'infinity' => esc_html__('Infinity scroll', 'utillz-core'),
                            ],
                            'allow_empty' => false
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'global_listing_cover_style',
                            'name' => esc_html__('Global cover style', 'utillz-core'),
                            'value' => 'landscape',
                            'options' => [
                                'landscape' => esc_html__('Landscape', 'utillz-core'),
                                'square' => esc_html__('Square', 'utillz-core'),
                                'portrait' => esc_html__('Portrait', 'utillz-core'),
                                'auto' => esc_html__('Automatic — Masonry', 'utillz-core'),
                            ],
                            'allow_empty' => false,
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'global_explore_type',
                            'name' => esc_html__('Global explore page type', 'utillz-core'),
                            'options' => apply_filters('utillz/display/explore/type', [
                                'default' => esc_html__('Default', 'utillz-core'),
                            ]),
                            'allow_empty' => false,
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'global_explore_columns',
                            'name' => esc_html__('Global explore columns', 'utillz-core'),
                            'options' => apply_filters('utillz/display/explore/columns', [
                                5 => esc_html__('20% — Small', 'utillz-core'),
                                4 => esc_html__('25% — Medium', 'utillz-core'),
                                3 => esc_html__('33% — Large', 'utillz-core'),
                                2 => esc_html__('50% — Supersize', 'utillz-core'),
                            ]),
                            'allow_empty' => false,
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'hide_edit_search_form',
                            'name' => esc_html__( 'Hide search form edit button', 'utillz-core' ),
                            'description' => esc_html__( 'Hide the edit button that appears when you are logged in as administrator', 'utillz-core' ),
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'global_search_form',
                            'name' => esc_html__( 'Global search form', 'utillz-core' ),
                            'description' => esc_html__( 'Filters will appear when you explore the main explore page with no listing type selected.', 'utillz-core' ),
                            'options' => [
                                'query' => [
                                    'post_type' => 'ulz_search_form',
                                    'posts_per_page' => -1,
                                ]
                            ],
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'global_search_form_more',
                            'name' => esc_html__( 'Global search form (more)', 'utillz-core' ),
                            'description' => esc_html__( 'Additional filters that will appear in a popup.', 'utillz-core' ),
                            'options' => [
                                'query' => [
                                    'post_type' => 'ulz_search_form',
                                    'posts_per_page' => -1,
                                ]
                            ],
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'number',
                            'id' => 'global_listings_per_page',
                            'name' => esc_html__('Global listings per page', 'utillz-core'),
                            'input_type' => 'stepper',
                            'format' => '%s listings',
                            'style' => 'v2',
                            'min' => 1,
                            'max' => 50,
                            'step' => 1,
                            'value' => 10,
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

        </section>

        <section class="ulz-sections" :class="{'ulz-none': tabMain !== 'integration'}">

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'maps'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Maps', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">
                    <?php

                        $form->render([
                            'type' => 'text',
                            'id' => 'mapbox_access_token',
                            'name' => esc_html__('Mapbox access token', 'utillz-core'),
                            'description' => __('To use Mapbox GL JS, you need to have a Mapbox <a href="https://docs.mapbox.com/help/getting-started/access-tokens/" target="_blank">access token</a>. This access token associates your map with a Mapbox account. For more information on creating and using access tokens, see our <a href="https://docs.mapbox.com/accounts/guides/tokens/" target="_blank">token management documentation</a>.', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'mapbox_style_url',
                            'name' => esc_html__('Mapbox style URL', 'utillz-core'),
                            'placeholder' => 'mapbox://styles/mapbox/streets-v11',
                            'description' => __('Learn more about <a href="https://docs.mapbox.com/api/maps/styles/" target="_blank">Mapbox styles</a>', 'utillz-core'),
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

            <aside class="ulz-section ulz-section-large" :class="{'ulz-none': tabSub !== 'account'}">
                <div class="ulz-panel-heading">
                    <h3 class="ulz-title"><?php esc_html_e( 'Account', 'utillz-core' ); ?></h3>
                </div>
                <div class="ulz-form ulz-grid">

                    <?php if( ! get_option( 'users_can_register' ) ): ?>
                        <div class="ulz-form-group ulz-col-12">
                            <div class="ulz-notice ulz-notice-alert">
                                <?php esc_html_e( 'User registration is disable for the current site. You can enable it from the WordPress settings', 'utillz-core' ); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_standard_pass',
                            'name' => esc_html__('Users can choose a password', 'utillz-core'),
                            'description' => esc_html__('Enable this option and allow your visitors to set their own password in the sign up process. This will bypass the default WordPress email verification.', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_standard_role',
                            'name' => esc_html__('Users can choose a role', 'utillz-core'),
                            'description' => esc_html__('The users will be able to select their role — customer or business', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'select',
                            'id' => 'default_user_role',
                            'name' => esc_html__('Select the default user role', 'utillz-core'),
                            'options' => [
                                'customer' => esc_html__('Customer', 'utillz-core'),
                                'business' => esc_html__('Business', 'utillz-core'),
                            ],
                            'value' => 'user',
                            'allow_empty' => false,
                            'dependency' => [
                                'id' => 'enable_standard_role',
                                'value' => 1,
                                'compare' => '!=',
                                'style' => 'ulz-opacity-30',
                            ],
                        ]);
						
                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_dashboard_role',
                            'name' => esc_html__('Users can change their role from the account dashboard', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_signup_phone',
                            'name' => esc_html__('Enable sign up phone number field', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'is_signup_phone_required',
                            'name' => esc_html__('Make phone number required', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_signup_phone',
                                'value' => 1,
                                'compare' => '=',
                            ],
                        ]);  
                        $form->render([
							'type' => 'checkbox',
							'id' => 'hide_notification_icon',
							'name' => esc_html__('Hide Notification Icon', 'utillz-core'),
						]);
						
						$form->render([
							'type' => 'checkbox',
							'id' => 'enable_author_details',
							'name' => esc_html__('Enable User or Author Contact Details On User Profile', 'routiz'),
							'value' => 0,
							'compare' => '=',
						]);
												
						
						
                       $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_signup_captcha',
                            'name' => esc_html__('Enable Sign Up Google Captcha', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'signup_captcha_key',
                            'name' => esc_html__('Google Captcha Site Key', 'utillz-core'),
                            'description' => __('Get one <a href="https://www.a2hosting.in/kb/security/obtaining-google-recaptcha-site-key-and-secret-key" target="_blank">here</a>.', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_signup_captcha',
                                'value' => 1,
                                'compare' => '=',
                            ],
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_signup_terms',
                            'name' => esc_html__('Enable sign up terms field', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'signup_terms_text',
                            'name' => esc_html__('Sign up terms text', 'utillz-core'),
                            'value' => esc_html__('I agree with the terms and conditions', 'utillz-core'),
                            'description' => esc_html__('You can use HTML tags and add a link to a terms page', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_signup_terms',
                                'value' => 1,
                                'compare' => '=',
                            ],
                        ]);

                        $form->render([
                            'type' => 'separator',
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_facebook_auth',
                            'name' => esc_html__('Enable facebook sign in', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'facebook_app_id',
                            'name' => esc_html__('Facebook API id', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_facebook_auth',
                                'value' => 1,
                                'compare' => '=',
                                'style' => 'ulz-opacity-30',
                            ],
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'facebook_app_secret',
                            'name' => esc_html__('Facebook API secret', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_facebook_auth',
                                'value' => 1,
                                'compare' => '=',
                                'style' => 'ulz-opacity-30',
                            ],
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'separator',
                        ]);

                        $form->render([
                            'type' => 'checkbox',
                            'id' => 'enable_google_auth',
                            'name' => esc_html__('Enable google sign in', 'utillz-core'),
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'google_client_id',
                            'name' => esc_html__('Google client ID', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_google_auth',
                                'value' => 1,
                                'compare' => '=',
                                'style' => 'ulz-opacity-30',
                            ],
                            'col' => 6
                        ]);

                        $form->render([
                            'type' => 'text',
                            'id' => 'google_client_secret',
                            'name' => esc_html__('Google client secret', 'utillz-core'),
                            'dependency' => [
                                'id' => 'enable_google_auth',
                                'value' => 1,
                                'compare' => '=',
                                'style' => 'ulz-opacity-30',
                            ],
                            'col' => 6
                        ]);

                    ?>

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large"  id="social_login_btn">
                            <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
                        </button>
                    </div>

                </div>
            </aside>

        </section>

        <?php do_action('utillz/settings/sections'); ?>

    </div>
</form>

<?php Ucore()->the_template('admin/modals/field-template/content'); ?>
<?php Ucore()->the_template('admin/modals/field-webhook/content'); ?>
